/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.API.SideReference;
import com.github.bartimaeusnek.bartworks.MainMod;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.common.items.LabParts;
import com.github.bartimaeusnek.bartworks.common.loaders.FluidLoader;
import com.github.bartimaeusnek.bartworks.common.net.RendererPacket;
import com.github.bartimaeusnek.bartworks.common.tileentities.tiered.GT_MetaTileEntity_RadioHatch;
import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.BioCulture;
import com.github.bartimaeusnek.bartworks.util.Coords;
import com.github.bartimaeusnek.bartworks.util.MathUtils;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_TileEntity_BioVat
extends GT_MetaTileEntity_MultiBlockBase {
    public static final HashMap<Coords, Integer> staticColorMap = new HashMap();
    private static final byte MCASING_INDEX = 49;
    private static final byte TIMERDIVIDER = 20;
    private final HashSet<EntityPlayerMP> playerMPHashSet = new HashSet();
    private final ArrayList<GT_MetaTileEntity_RadioHatch> mRadHatches = new ArrayList();
    private int height = 1;
    private GT_Recipe mLastRecipe;
    private Fluid mFluid = FluidRegistry.LAVA;
    private BioCulture mCulture;
    private ItemStack mStack;
    private boolean needsVisualUpdate = true;
    private byte mGlassTier;
    private int mSievert;
    private int mNeededSievert;

    public GT_TileEntity_BioVat(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_BioVat(String aName) {
        super(aName);
    }

    public static int[] specialValueUnpack(int aSpecialValue) {
        int[] ret = new int[]{aSpecialValue & 0xF, aSpecialValue >>> 4 & 3, aSpecialValue >>> 6 & 1, aSpecialValue >>> 7 & Integer.MAX_VALUE};
        return ret;
    }

    public boolean isLiquidInput(byte aSide) {
        return false;
    }

    public boolean isLiquidOutput(byte aSide) {
        return false;
    }

    private int getInputCapacity() {
        return this.mInputHatches.stream().mapToInt(GT_MetaTileEntity_Hatch_Input::getCapacity).sum();
    }

    private int getOutputCapacity() {
        return this.mOutputHatches.stream().mapToInt(GT_MetaTileEntity_Hatch_Output::getCapacity).sum();
    }

    public int getCapacity() {
        int ret = 0;
        return ret += this.getInputCapacity();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return super.fill(resource, doFill);
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return BWRecipes.instance.getMappingsFor((byte)1);
    }

    private int calcMod(double x) {
        double y = (double)this.getOutputCapacity() / 2.0;
        double z = ConfigHandler.bioVatMaxParallelBonus;
        int ret = MathUtils.ceilInt((-1.0 / y * Math.pow(x - y, 2.0) + y) / y * z);
        return MathUtils.clamp(1, ret, ConfigHandler.bioVatMaxParallelBonus);
    }

    private List<ItemStack> getItemInputs() {
        ArrayList tInputList = this.getStoredInputs();
        int tInputList_sS = tInputList.size();
        block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
            for (int j = i + 1; j < tInputList_sS; ++j) {
                if (!GT_Utility.areStacksEqual((ItemStack)((ItemStack)tInputList.get(i)), (ItemStack)((ItemStack)tInputList.get(j)))) continue;
                if (((ItemStack)tInputList.get((int)i)).field_77994_a >= ((ItemStack)tInputList.get((int)j)).field_77994_a) {
                    tInputList.remove(j--);
                    tInputList_sS = tInputList.size();
                    continue;
                }
                tInputList.remove(i--);
                tInputList_sS = tInputList.size();
                continue block0;
            }
        }
        return tInputList;
    }

    private List<FluidStack> getFluidInputs() {
        ArrayList tFluidList = this.getStoredFluids();
        int tFluidList_sS = tFluidList.size();
        block0: for (int i = 0; i < tFluidList_sS - 1; ++i) {
            for (int j = i + 1; j < tFluidList_sS; ++j) {
                if (!GT_Utility.areFluidsEqual((FluidStack)((FluidStack)tFluidList.get(i)), (FluidStack)((FluidStack)tFluidList.get(j)))) continue;
                if (((FluidStack)tFluidList.get((int)i)).amount >= ((FluidStack)tFluidList.get((int)j)).amount) {
                    tFluidList.remove(j--);
                    tFluidList_sS = tFluidList.size();
                    continue;
                }
                tFluidList.remove(i--);
                tFluidList_sS = tFluidList.size();
                continue block0;
            }
        }
        return tFluidList;
    }

    public boolean checkRecipe(ItemStack itemStack) {
        GT_Recipe.GT_Recipe_Map gtRecipeMap = this.getRecipeMap();
        if (gtRecipeMap == null) {
            return false;
        }
        ItemStack[] tInputs = this.getItemInputs().toArray(new ItemStack[0]);
        FluidStack[] tFluids = this.getFluidInputs().toArray(new FluidStack[0]);
        if (tFluids.length > 0) {
            GT_Recipe gtRecipe = gtRecipeMap.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, this.getMaxInputVoltage(), tFluids, itemStack, tInputs);
            if (gtRecipe == null) {
                return false;
            }
            if (!BW_Util.areStacksEqualOrNull((ItemStack)gtRecipe.mSpecialItems, itemStack)) {
                return false;
            }
            int[] conditions = GT_TileEntity_BioVat.specialValueUnpack(gtRecipe.mSpecialValue);
            this.mNeededSievert = conditions[3];
            if (conditions[2] == 0 ? this.mSievert < this.mNeededSievert || this.mGlassTier < conditions[0] : this.mSievert != conditions[3] || this.mGlassTier < conditions[0]) {
                return false;
            }
            int times = 1;
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            Set<FluidStack> storedFluidOutputs = this.getStoredFluidOutputs();
            if (gtRecipe.isRecipeInputEqual(true, tFluids, tInputs)) {
                if (storedFluidOutputs.size() > 0) {
                    this.mOutputFluids = new FluidStack[gtRecipe.mFluidOutputs.length];
                    for (FluidStack storedOutputFluid : storedFluidOutputs) {
                        if (!storedOutputFluid.isFluidEqual(gtRecipe.getFluidOutput(0))) continue;
                        for (FluidStack inputFluidStack : gtRecipe.mFluidInputs) {
                            int j = this.calcMod(storedOutputFluid.amount);
                            for (int i = 0; i < j; ++i) {
                                if (!this.depleteInput(inputFluidStack)) continue;
                                ++times;
                            }
                        }
                    }
                    for (FluidStack storedfluidStack : storedFluidOutputs) {
                        for (int i = 0; i < gtRecipe.mFluidOutputs.length; ++i) {
                            if (!storedfluidStack.isFluidEqual(gtRecipe.getFluidOutput(i))) continue;
                            this.mOutputFluids[i] = new FluidStack(gtRecipe.getFluidOutput(i), times * gtRecipe.getFluidOutput((int)0).amount);
                        }
                    }
                } else {
                    this.mOutputFluids = gtRecipe.mFluidOutputs;
                }
            } else {
                return false;
            }
            BW_Util.calculateOverclockedNessMulti(gtRecipe.mEUt, gtRecipe.mDuration, 1, this.getMaxInputVoltage(), this);
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mProgresstime = 0;
            if (gtRecipe.mCanBeBuffered) {
                this.mLastRecipe = gtRecipe;
            }
            this.updateSlots();
            return true;
        }
        return false;
    }

    public Set<FluidStack> getStoredFluidOutputs() {
        return this.mOutputHatches.stream().map(GT_MetaTileEntity_BasicTank::getFluid).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private boolean addRadiationInputToMachineList(IGregTechTileEntity aTileEntity) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_RadioHatch) {
            ((GT_MetaTileEntity_RadioHatch)aMetaTileEntity).updateTexture(49);
            return this.mRadHatches.add((GT_MetaTileEntity_RadioHatch)aMetaTileEntity);
        }
        return false;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX * 2;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ * 2;
        int blockcounter = 0;
        this.mRadHatches.clear();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = 0; y < 4; ++y) {
                    IGregTechTileEntity tileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z);
                    if (y == 0 || y == 3) {
                        if (y == 0 && xDir + x == 0 && zDir + z == 0 || this.addOutputToMachineList(tileEntity, 49) || this.addRadiationInputToMachineList(tileEntity) || this.addInputToMachineList(tileEntity, 49) || this.addMaintenanceToMachineList(tileEntity, 49) || this.addEnergyInputToMachineList(tileEntity, 49)) continue;
                        if (BW_Util.addBlockToMachine(x, y, z, 2, aBaseMetaTileEntity, GregTech_API.sBlockCasings4, 1)) {
                            ++blockcounter;
                            continue;
                        }
                        return false;
                    }
                    if (Math.abs(x) < 2 && Math.abs(z) != 2) {
                        if (BW_Util.addBlockToMachine(x, y, z, 2, aBaseMetaTileEntity, Blocks.field_150350_a) || BW_Util.addBlockToMachine(x, y, z, 2, aBaseMetaTileEntity, FluidLoader.bioFluidBlock)) continue;
                        return false;
                    }
                    if (x == -2 && z == -2 && y == 1) {
                        this.mGlassTier = BW_Util.calculateGlassTier(aBaseMetaTileEntity.getBlockOffset(xDir + -2, y, zDir + z), aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z));
                    }
                    if (0 != this.mGlassTier && this.mGlassTier == BW_Util.calculateGlassTier(aBaseMetaTileEntity.getBlockOffset(xDir + x, y, zDir + z), aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z))) continue;
                    return false;
                }
            }
        }
        if (blockcounter > 18 && this.mRadHatches.size() < 2 && this.mOutputHatches.size() == 1 && this.mMaintenanceHatches.size() == 1 && this.mInputHatches.size() > 0) {
            return this.mEnergyHatches.size() > 0;
        }
        return false;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    private void sendAllRequiredRendererPackets() {
        int height = this.reCalculateHeight();
        if (this.mFluid != null && height > 1 && this.reCalculateFluidAmmount() > 0) {
            for (int x = -1; x < 2; ++x) {
                for (int y = 1; y < height; ++y) {
                    for (int z = -1; z < 2; ++z) {
                        this.sendPackagesOrRenewRenderer(x, y, z, this.mCulture);
                    }
                }
            }
        }
    }

    private void sendPackagesOrRenewRenderer(int x, int y, int z, BioCulture lCulture) {
        int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX * 2;
        int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ * 2;
        staticColorMap.remove(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g));
        staticColorMap.put(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g), lCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : lCulture.getColorRGB());
        if (SideReference.Side.Server) {
            MainMod.BW_Network_instance.sendPacketToAllPlayersInRange(this.getBaseMetaTileEntity().getWorld(), new RendererPacket(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g), lCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : lCulture.getColorRGB(), true), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
            MainMod.BW_Network_instance.sendPacketToAllPlayersInRange(this.getBaseMetaTileEntity().getWorld(), new RendererPacket(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g), lCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : lCulture.getColorRGB(), false), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
        }
        this.needsVisualUpdate = true;
    }

    private void check_Chunk() {
        World aWorld = this.getBaseMetaTileEntity().getWorld();
        if (!aWorld.field_72995_K) {
            for (Object tObject : aWorld.field_73010_i) {
                if (!(tObject instanceof EntityPlayerMP)) break;
                EntityPlayerMP tPlayer = (EntityPlayerMP)tObject;
                Chunk tChunk = aWorld.func_72938_d(this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
                if (tPlayer.func_71121_q().func_73040_p().func_72694_a(tPlayer, tChunk.field_76635_g, tChunk.field_76647_h)) {
                    if (this.playerMPHashSet.contains(tPlayer)) continue;
                    this.playerMPHashSet.add(tPlayer);
                    this.sendAllRequiredRendererPackets();
                    continue;
                }
                this.playerMPHashSet.remove(tPlayer);
            }
        }
    }

    private void placeFluid() {
        int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX * 2;
        int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ * 2;
        this.height = this.reCalculateHeight();
        if (this.mFluid != null && this.height > 1 && this.reCalculateFluidAmmount() > 0) {
            for (int x = -1; x < 2; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    for (int z = -1; z < 2; ++z) {
                        if (!this.getBaseMetaTileEntity().getWorld().func_147439_a(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord()).equals(Blocks.field_150350_a)) continue;
                        this.getBaseMetaTileEntity().getWorld().func_147449_b(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), FluidLoader.bioFluidBlock);
                    }
                }
            }
        }
    }

    private int reCalculateFluidAmmount() {
        return this.getStoredFluids().stream().mapToInt(fluidStack -> fluidStack.amount).sum();
    }

    private int reCalculateHeight() {
        return this.reCalculateFluidAmmount() > this.getCapacity() / 4 - 1 ? (this.reCalculateFluidAmmount() >= this.getCapacity() / 2 ? 3 : 2) : 1;
    }

    public void doAllVisualThings() {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.mMachine) {
                int z;
                int y;
                int x;
                ItemStack aStack = this.mInventory[1];
                BioCulture lCulture = null;
                int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX * 2;
                int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ * 2;
                if (this.getBaseMetaTileEntity().getTimer() % 200L == 0L) {
                    this.check_Chunk();
                }
                if (this.needsVisualUpdate && this.getBaseMetaTileEntity().getTimer() % 20L == 0L) {
                    for (x = -1; x < 2; ++x) {
                        for (y = 1; y < 3; ++y) {
                            for (z = -1; z < 2; ++z) {
                                this.getBaseMetaTileEntity().getWorld().func_147468_f(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord());
                            }
                        }
                    }
                }
                this.height = this.reCalculateHeight();
                if (this.mFluid != null && this.height > 1 && this.reCalculateFluidAmmount() > 0) {
                    if (!BW_Util.areStacksEqualOrNull(aStack, this.mStack) || this.needsVisualUpdate && this.getBaseMetaTileEntity().getTimer() % 20L == 1L) {
                        for (x = -1; x < 2; ++x) {
                            for (y = 1; y < this.height; ++y) {
                                for (z = -1; z < 2; ++z) {
                                    if (aStack != null && (!(aStack.func_77973_b() instanceof LabParts) || aStack.func_77960_j() != 0) || this.mCulture != null && aStack != null && aStack.func_77978_p() != null && this.mCulture.getID() == aStack.func_77978_p().func_74762_e("ID")) continue;
                                    lCulture = aStack == null || aStack.func_77978_p() == null ? null : BioCulture.getBioCulture(aStack.func_77978_p().func_74779_i("Name"));
                                    this.sendPackagesOrRenewRenderer(x, y, z, lCulture);
                                }
                            }
                        }
                        this.mStack = aStack;
                        this.mCulture = lCulture;
                    }
                    if (this.needsVisualUpdate && this.getBaseMetaTileEntity().getTimer() % 20L == 1L) {
                        if (this.getBaseMetaTileEntity().isClientSide()) {
                            new Throwable().printStackTrace();
                        }
                        this.placeFluid();
                        this.needsVisualUpdate = false;
                    }
                }
            } else {
                this.onRemoval();
            }
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.height != this.reCalculateHeight()) {
            this.needsVisualUpdate = true;
        }
        this.doAllVisualThings();
        if (this.getBaseMetaTileEntity().isServerSide() && this.mRadHatches.size() == 1) {
            this.mSievert = this.mRadHatches.get(0).getSievert();
            if (this.getBaseMetaTileEntity().isActive() && this.mNeededSievert > this.mSievert) {
                this.mOutputFluids = null;
            }
        }
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mFluidHeight", this.height);
        if (this.mCulture != null && !this.mCulture.getName().isEmpty()) {
            aNBT.func_74778_a("mCulture", this.mCulture.getName());
        } else if ((this.mCulture == null || this.mCulture.getName().isEmpty()) && !aNBT.func_74779_i("mCulture").isEmpty()) {
            aNBT.func_82580_o("mCulture");
        }
        if (this.mFluid != null) {
            aNBT.func_74778_a("mFluid", this.mFluid.getName());
        }
        aNBT.func_74768_a("mSievert", this.mSievert);
        aNBT.func_74768_a("mNeededSievert", this.mNeededSievert);
        super.saveNBTData(aNBT);
    }

    public void onRemoval() {
        int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX * 2;
        int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ * 2;
        for (int x = -1; x < 2; ++x) {
            for (int y = 1; y < 3; ++y) {
                for (int z = -1; z < 2; ++z) {
                    if (this.getBaseMetaTileEntity().getWorld().func_147439_a(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord()).equals(FluidLoader.bioFluidBlock)) {
                        this.getBaseMetaTileEntity().getWorld().func_147468_f(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord());
                    }
                    staticColorMap.remove(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord()), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g);
                    if (!SideReference.Side.Server) continue;
                    MainMod.BW_Network_instance.sendPacketToAllPlayersInRange(this.getBaseMetaTileEntity().getWorld(), new RendererPacket(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g), this.mCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : this.mCulture.getColorRGB(), true), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
                }
            }
        }
        super.onRemoval();
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.height = aNBT.func_74762_e("mFluidHeight");
        this.mCulture = BioCulture.getBioCulture(aNBT.func_74779_i("mCulture"));
        if (!aNBT.func_74779_i("mFluid").isEmpty()) {
            this.mFluid = FluidRegistry.getFluid((String)aNBT.func_74779_i("mFluid"));
        }
        this.mSievert = aNBT.func_74762_e("mSievert");
        this.mNeededSievert = aNBT.func_74762_e("mNeededSievert");
        super.loadNBTData(aNBT);
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_BioVat(this.mName);
    }

    public String[] getDescription() {
        String[] dsc = StatCollector.func_74838_a((String)"tooltip.tile.bvat.0.name").split(";");
        String[] fdsc = new String[dsc.length + 1];
        for (int i = 0; i < dsc.length; ++i) {
            fdsc[i] = dsc[i];
            fdsc[dsc.length] = BW_Tooltip_Reference.ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS.get();
        }
        return fdsc;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aSide == aFacing) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.CASING_BLOCKS[49];
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER));
        } else {
            ITexture[] iTextureArray3 = new ITexture[1];
            iTextureArray = iTextureArray3;
            iTextureArray3[0] = Textures.BlockIcons.CASING_BLOCKS[49];
        }
        return iTextureArray;
    }
}

